/*
 * Use at your own risk.
 *
 * Copyright (C) 2005-2008 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

XXX THIS DOES NOT USE BUILT-IN DETECTION FUNCTION XXX

NOT ONLY THAT, THIS RULE DOESN'T ACTUALLY WORK; IT'S JUST THERE TO PROVIDE THE PIECES FOR ASSEMBLY!

alert tcp $EXTERNAL_NET $HTTP_PORTS -> $HOME_NET any (msg:"Microsoft GDI bitmapcoreheader buffer overflow attempt"; flow:to_client,established; flowbits:isset,file.emf; content:" EMF|00 00 01 00|"; content:"|01 00 00 00|"; distance:-48; within:4; byte_jump:4,0,relative,little; content:"|5e 00 00 00|"; distance:-8; within:4; content:"|51 00 00 00|"; distance:-8; within:4; metadata:policy security-ips drop; reference:cve,2008-1087; reference:url,technet.microsoft.com/en-us/security/bulletin/MS08-021; classtype:attempted-user; sid:13666; rev:1;)

NOTE: Technically, any record that includes a BITMAPCOREHEADER is able to be used to exploit this vulnerability.  However,
the information available is sparse and scattered.  We're going to provide coverage for the example and if necessary at
a later date we'll add more structures.

 */


#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util.h"

//#define DEBUG 1
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

#ifndef EMR
#define EMR_STRETCHDIBITS           0x51
#define EMR_CREATEDIBPATTERNBRUSHPT 0x5E
#endif

/* declare detection functions */
int rule13666eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_client; */
static FlowFlags rule13666flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_CLIENT
};

static RuleOption rule13666option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13666flow0
    }
};
/* flowbits:isset "file.emf"; */
static FlowBitsInfo rule13666flowbits1 =
{
    "file.emf",
    FLOWBIT_ISSET,
    0,
};

static RuleOption rule13666option1 =
{
    OPTION_TYPE_FLOWBIT,
    {
        &rule13666flowbits1
    }
};
// content:" EMF|00 00 01 00|"; 
static ContentInfo rule13666content2 = 
{
    (uint8_t *) " EMF|00 00 01 00|", /* pattern (now in snort content format) */
    0, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13666option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13666content2
    }
};
// content:"|01 00 00 00|", offset -48, depth 4, relative; 
static ContentInfo rule13666content3 = 
{
    (uint8_t *) "|01 00 00 00|", /* pattern (now in snort content format) */
    4, /* depth */
    -48, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13666option3 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13666content3
    }
};
/* byte_jump:size 4, relative, endian little; */
static ByteData rule13666byte_jump4 = 
{
4, /* size */
    0, /* operator, byte_jump doesn't use operator! */
    0, /* value, byte_jump doesn't use value! */
    0, /* offset */
    0, /* multiplier */
    BYTE_LITTLE_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE /* flags */
};

static RuleOption rule13666option4 = 
{
    OPTION_TYPE_BYTE_JUMP,
    {
        &rule13666byte_jump4
    }
};
// content:"^|00 00 00|", offset -8, depth 4, relative; 
static ContentInfo rule13666content5 = 
{
    (uint8_t *) "^|00 00 00|", /* pattern (now in snort content format) */
    4, /* depth */
    -8, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13666option5 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13666content5
    }
};

// content:"|51 00 00 00|", offset -8, depth 4, relative; 
static ContentInfo rule13666content6 = 
{
    (uint8_t *) "|51 00 00 00|", /* pattern (now in snort content format) */
    4, /* depth */
    -8, /* offset */
    CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13666option6 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13666content6
    }
};

/* references for sid 13666 */
/* reference: cve "2008-1087"; */
static RuleReference rule13666ref1 = 
{
    "cve", /* type */
    "2008-1083" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/MS08-021"; */
static RuleReference rule13666ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/MS08-021" /* value */
};

static RuleReference *rule13666refs[] =
{
    &rule13666ref1,
    &rule13666ref2,
    NULL
};
/* metadata for sid 13666 */
/* metadata:policy security-ips drop; */

//static RuleMetaData rule13666policy1 = 
//{
//    "policy security-ips drop"
//};


static RuleMetaData *rule13666metadata[] =
{
//    &rule13666policy1,
    NULL
};
RuleOption *rule13666options[] =
{
    &rule13666option0,
    &rule13666option1,
    &rule13666option2,
    &rule13666option3,
    &rule13666option4,
    &rule13666option5,
    &rule13666option6,
    NULL
};

Rule rule13666 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "$HTTP_PORTS", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "any", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13666, /* sigid */
       12, /* revision */
   
       "attempted-user", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Windows GDI integer overflow attempt",     /* message */
       rule13666refs /* ptr to references */
       ,rule13666metadata
   },
   rule13666options, /* ptr to rule options */
   &rule13666eval, /* DOES NOT use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13666eval(void *p) {
    const uint8_t *cursor_normal = 0, *cursor_offBmi;
    SFSnortPacket *sp = (SFSnortPacket *) p;

    const uint8_t *record_size_ptr, *beg_of_payload, *end_of_payload;

    uint32_t recordType, offBmi, bcSize;
    uint16_t bcWidth,bcHeight,bcPlanes,bcBitCount;
    uint64_t Value;  // For storing exploit calculations

    if(sp == NULL)
        return RULE_NOMATCH;

    if(sp->payload == NULL)
        return RULE_NOMATCH;
    
    // flow:established, to_client;
    if (checkFlow(p, rule13666options[0]->option_u.flowFlags) <= 0 )
        return RULE_NOMATCH;
    
    // flowbits:isset "file.emf";
    if (processFlowbits(p, rule13666options[1]->option_u.flowBit) <= 0)
        return RULE_NOMATCH;
    
    // content:" EMF|00 00 01 00|";
    if (contentMatch(p, rule13666options[2]->option_u.content, &cursor_normal) > 0) {
        // content:"|01 00 00 00|", offset -48, depth 4, relative;
        if (contentMatch(p, rule13666options[3]->option_u.content, &cursor_normal) > 0) {
            // byte_jump:size 4, relative, endian little;
            if (byteJump(p, rule13666options[4]->option_u.byte, &cursor_normal) > 0) {
                
                if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &beg_of_payload, &end_of_payload) <= 0)
                    return RULE_NOMATCH;

                // Now we're at the start of records.  Find the interesting ones.
                while(cursor_normal < end_of_payload) {
                     
                    // We point to record size so we're at the right state for the relative jump
                    // if it turns out the record doesn't have a BITMAPCOREHEADER. 
                    record_size_ptr = cursor_normal - 4;                    

                    // content:"|5E 00 00 00|", offset -8, depth 4, relative;  XXX /* EMR_CREATEDIBPATTERNBRUSHPT */
                    if (contentMatch(p, rule13666options[5]->option_u.content, &cursor_normal) > 0
                        // content:"|51 00 00 00|", offset -8, depth 4, relative; XXX /* EMR_STRETCHDIBITS */
                        || (contentMatch(p, rule13666options[6]->option_u.content, &cursor_normal) > 0))
                    {
                        recordType = *(cursor_normal - 4);
                        switch(recordType)
                        {
                            case EMR_CREATEDIBPATTERNBRUSHPT:
                                DEBUG_SO(printf("matched EMR_CREATEDIBPATTERNBRUSHPT\n");)
                                    
                                if (cursor_normal + 28 > end_of_payload) // Make sure there's enough room
                                    return RULE_NOMATCH;

                                // extract offset to BITMAPCOREHEADER.  can't use byte_jump because it could put us
                                // past end of packet since the "jump" actually starts from an earlier offset
                                cursor_offBmi = cursor_normal + 12;
                                offBmi = read_little_32(cursor_offBmi);
                                break;
                                    
                            case EMR_STRETCHDIBITS: 
                                DEBUG_SO(printf("matched EMR_STRETCHDIBITS\n");)

                                if (cursor_normal + 60 > end_of_payload) 
                                    return RULE_NOMATCH;
                        
                                // read offBmiSrc field 
                                cursor_offBmi = cursor_normal + 44;
                                offBmi = read_little_32(cursor_offBmi);
                                break;
                                
                            default:
                                DEBUG_SO(printf("This case must not happen\n");)
                                return RULE_NOMATCH;                                    
                        }
                                    
                        if (offBmi + cursor_normal - 4 < cursor_normal)  // check integer overflow
                            return RULE_NOMATCH;

                        // move cursor to the beginning of a device independent bitmap (DIB)
                        DEBUG_SO(printf("offBmi=0x%08x\n", offBmi);)  
                        cursor_normal += offBmi - 4; 
                                  
                        if(cursor_normal + 12 > end_of_payload)
                           return RULE_NOMATCH;
                                  
                        // match size of BITMAPCOREHEADER to determine if it's the proper structure
                        bcSize = read_little_32(cursor_normal);
                        cursor_normal += 4;
                        DEBUG_SO(printf("bcSize=0x%08x\n", bcSize);)
        
                        if (bcSize == 12) // checks BITMAPCOREHEADER
                        {
                            bcWidth = read_little_16(cursor_normal);
                            cursor_normal += 2;
        
                            bcHeight = read_little_16(cursor_normal);
                            cursor_normal += 2;
        
                            bcPlanes = read_little_16(cursor_normal);
                            cursor_normal += 2;
        
                            bcBitCount = read_little_16(cursor_normal);
                            cursor_normal += 2;
        
                            DEBUG_SO(printf("bcWidth=%xh bcHeight=%xh bcPlanes=%xh bcBitCount=%xh\n", bcWidth,bcHeight,bcPlanes,bcBitCount);)

                            // 16-bit * 16-bit can't be more than 32-bit
                            Value = (bcWidth * bcPlanes) & 0xFFFFFFFF;
        
                            if((Value *= bcBitCount) > 0xFFFFFFFF)
                                return RULE_MATCH;
        
                            if((Value += 31) > 0xFFFFFFFF)
                                return RULE_MATCH;
        
                            Value &= ~31; // turn off lower 5 bits (make evenly divisible by 8)
                            Value /= 8;
                            Value *= bcHeight;
        
                            if(Value > 0xFFFFFFFF)
                                return RULE_MATCH;
        
                            if((Value += 256 * 4) > 0xFFFFFFFF)
                                return RULE_MATCH;

                            if ((recordType == EMR_STRETCHDIBITS)
                                && (bcBitCount == 1 || bcBitCount == 4 || bcBitCount == 8))
                                return RULE_MATCH;       
                        }                                
                    }
                        
                    cursor_normal = record_size_ptr;
                    // relative jump to next record using existing byte jump for size
                    if (byteJump(p, rule13666options[4]->option_u.byte, &cursor_normal) <= 0)
                        return RULE_NOMATCH;

                    if((cursor_normal - 4) <= record_size_ptr) // Someone's messing with us, or bogus data
                        return RULE_NOMATCH;                                                            
                }
            }
        }
    }
    return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13666,
    NULL
};
*/

